<?php

class AdminVisitorModel extends CI_Model
{
    protected $table = 'subscriber';
    protected $key = 'id';

    

    public function getNewVisitorCount()
    {
        $this->db->from('subscriber');
        $query = $this->db->get();
        return $query->num_rows();
    }

    
    public function subscriberList()
    {
        $this->db->select('
        subscriber.*
        ');
        $query = $this->db->get('subscriber');
        return $query->result();
    }

    public function flatList()
    {
        $this->db->select('
            flats.*
        ');
        $query = $this->db->get('flats');
        return $query->result();
    }

    public function getSubscriberCount()
    {
        $this->db->from('subscriber');
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function getFlatsCount()
    {
        $this->db->from('flats');
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function getFlatOwnerCount()
    {
        $this->db->from('flat_owners');
        $query = $this->db->get();
        return $query->num_rows();
    }

    function dashboard_chart_users($date1)
	{
		$this->db->like('created_at', $date1);
		$this->db->from('users');
		return $this->db->count_all_results();
	}
    
	function dashboard_chart_sitevisits($date1)
	{
		
		$this->db->from('subscriber');
		return $this->db->count_all_results();
	}

    public function getFlatDetails($column='',$value='')
    {
        $this->db->where($column, $value);
        $this->db->select('
            flats.*
        ');
        $this->db->join('flat_owners', 'flat_owners.flat_id = flats.flat_id', 'left');
        $this->db->join('users', 'flat_owners.user_id = users.user_id', 'left');
        $result = $this->db->get('flats');
        return ($result->num_rows() == 1) ? $result->row(0) : $this->emptyObject('flats');
    }

    public function getFlatOwner($column='',$value='')
    {
        $this->db->where($column, $value);
        $this->db->select('
            users.username
        ');
        $this->db->join('flat_owners', 'flat_owners.flat_id = flats.flat_id', 'left');
        $this->db->join('users', 'flat_owners.user_id = users.user_id', 'left');
        $result = $this->db->get('flats');
        return ($result->num_rows() == 1) ? $result->row(0) : $this->emptyObject('flats');
    }

    public function storeFlatOwner($user_id='',$flat_id='')
    {
        $data['user_id'] = $user_id;
        $data['flat_id'] = $flat_id;
        $this->db->insert('flat_owners', $data);
        $id = $this->db->insert_id();
        return $id;
    }

    public function getSubscribersForCSV($ids)
    {
        
        $this->db->from('subscriber');
        $this->db->select("
                subscriber.firstname as First Name,
                subscriber.lastname as Last Name,
                subscriber.companyname as Company Name,

                subscriber.email as No of Email,
                subscriber.phone as Visting Phone,
                subscriber.business_address as Business Address,
                
                subscriber.city as City,
                subscriber.state as State,
                subscriber.zcode as Zip Code,

                subscriber.business_setup_asst as Business Setup Assistance,
                subscriber.bidding_assistance as Contract Finding and/or Bidding Assistance,
                subscriber.currently_certified as Currently Certified,

                subscriber.bid_for_contract as Bid for a Contract,
                subscriber.interest_free_contract as Interest in Contract Ready LA Assistance Program,
                subscriber.noify as Noty Me
        ");
        $this->db->where_in('subscriber.id', explode(',', $ids));
        $this->db->group_by('subscriber.id');
        $query = $this->db->get();
        return $query->result();
    }

    public function subscribersList()
    {
       
        $request = $this->input->get();
        $columns = array(
            "subscriber.id",

            "subscriber.firstname",
            "subscriber.lastname",
            "subscriber.companyname",

            "subscriber.email",
            "subscriber.phone",
            "subscriber.business_address",

            "subscriber.city",
            "subscriber.state",
            "subscriber.zcode",

            "subscriber.business_setup_asst",
            "subscriber.bidding_assistance",
            "subscriber.currently_certified",

            "subscriber.bid_for_contract",
            "subscriber.interest_free_contract",
            "subscriber.noify"
        );
        $orderColumn = $columns[($request['order'][0]['column'] == 0 ? 5 : $request['order'][0]['column'])];
        $orderDirection = $request['order'][0]['dir'];
        $srh = $request['search']['value'];
        $limit = $request['length'];
        $offset = $request['start'];

        $this->db->from('subscriber');
        date_default_timezone_set('Asia/Calcutta');
        
        if ($srh) {
            $this->db->group_start()->like('subscriber.firstname', $srh)->or_like('subscriber.lastname', $srh)->or_like('subscriber.email', $srh)
                ->or_like('subscriber.phone', $srh)->or_like('subscriber.business_address', $srh)->group_end();
        }
        
        $this->db->group_by('subscriber.id');
        $this->db->order_by($orderColumn, $orderDirection);
        $this->db->limit($limit, $offset);
        $query = $this->db->get();

        $result = array(
            'data' => $this->prepareDataForTable($query->result()),
            'recordsTotal' => $this->getTotal(),
            'recordsFiltered' => $this->getTotal($srh, $request),
        );

        
        return $result;
    }

    public function getTotal($srh = false, $request = '')
    {
        $this->db->from('subscriber');
        date_default_timezone_set('Asia/Calcutta');
        // $date = date('Y-m-d', time());
        // $this->db->where('visiting_date >', $date);
        if (isset($this->session->userdata('admin')['user_type']) && 
                $this->session->userdata('admin')['user_type'] == 'Flat Owner') { 
            $this->db->where('visit_unit', $this->session->userdata('admin')['flats']['flat_id']);
        }
        if ($srh) {
            $this->db->group_start()->like('subscriber.firstname', $srh)->or_like('subscriber.lastname', $srh)->or_like('subscriber.email', $srh)
                ->or_like('subscriber.phone', $srh)->or_like('subscriber.business_address', $srh)->group_end();
        }
        
        $this->db->group_by('subscriber.id');
        $query = $this->db->get();
        return $query->num_rows();
    }

    private function prepareDataForTable($users)
    {
        $sorted = array();
        foreach ($users as $u) {
            $actions = '-';
            $u = objToArr($u);
            
            // $id_url = base_url()."assets/images/subscribers/".$u['id_proof'];
            // $id_proof = "<a target='blank' href='$id_url'>View Document</a>";

            $sorted[] = array(
                "<input type='checkbox' class='minimal single-check' data-id='".$u['id']."' />",
                esc_output($u['firstname'], 'html'),
                esc_output($u['lastname'], 'html'),
                esc_output($u['companyname'], 'html'),

                esc_output($u['email'], 'html'),
                esc_output($u['phone'], 'html'),
                esc_output($u['business_address'], 'html'),

                esc_output($u['city'], 'html'),
                esc_output($u['state'], 'html'),
                esc_output($u['zcode'], 'html'),

                esc_output($u['business_setup_asst'], 'html'),
                esc_output($u['bidding_assistance'], 'html'),
                esc_output($u['currently_certified'], 'html'),

                esc_output($u['bid_for_contract'], 'html'),
                esc_output($u['interest_free_contract'], 'html'),
                esc_output($u['noify'], 'html')
            );
        }
        return $sorted;
    }

}