
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="Wilio Survey, Quotation, Review and Register form Wizard by Ansonika.">
    <meta name="author" content="Ansonika">
    <title>Wilio | Survey, Quotation, Review and Register form Wizard</title>

 

    <!-- GOOGLE WEB FONT -->
    <link href="https://fonts.googleapis.com/css?family=Work+Sans:400,500,600" rel="stylesheet">

    <!-- BASE CSS -->
    <link href="css/bootstrap.min.css" rel="stylesheet">
	  <link href="css/menu.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
	  <link href="css/vendors.css" rel="stylesheet">

    <!-- YOUR CUSTOM CSS -->
    <link href="css/custom.css" rel="stylesheet">
	
	<!-- MODERNIZR MENU -->
	<script src="js/modernizr.js"></script>
	

</head>

<body>
	
	<div id="preloader">
		<div data-loader="circle-side"></div>
	</div><!-- /Preload -->
	
	<div id="loader_form">
		<div data-loader="circle-side-2"></div>
	</div><!-- /loader_form -->
	<div class="container-fluid full-height">
		<div class="row row-height">
			<div class="col-lg-8 content-left">
				<div class="content-left-wrapper">
				</div>
				<!-- /content-left-wrapper -->
			</div>
			<!-- /content-left -->

			<div class="col-lg-4 content-right" id="start">
				<div id="wizard_container">
					<div id="top-wizard">
							<div id="progressbar"></div>
						</div>
						<!-- /top-wizard -->
						<form id="contactForm">
							<input id="website" name="website" type="text" value="">
							<!-- Leave for security protection, read docs for details -->
							<div id="middle-wizard">
								<div class="step">
									<h3 class="main_question">Sign Up Today</h3>
                                    <div class="row">
									<div class="form-group col-sm-6">
										<input type="text" name="firstname" id="firstname" class="form-control required" placeholder="First Name">
									</div>
									<div class="form-group col-sm-6">
										<input type="text" name="lastname" id="lastname" class="form-control required" placeholder="Last Name">
									</div>
									<div class="form-group">
										<input type="text" name="cname" id="cname" class="form-control required" placeholder="Company Name">
									</div>
                                    
                                    <div class="form-group">
										<input type="email" name="email" id="email" class="form-control required" placeholder="Email">
									</div>
                                    
                                    <div class="form-group">
										<input type="text" name="contact" id="contact" class="form-control required" placeholder="Phone: 555-555-5555">
									</div>
                                    
                                    
                                    
                                    <div class="form-group">
										<input type="text" name="business_address" id="business_address" class="form-control required" placeholder="Business Address">
									</div>
                                    
                                    </div>
									
									<div class="row">
										<div class="col-4">
											<div class="form-group">
												<input type="text" name="city" id="city" class="form-control" placeholder="City">
											</div>
										</div>
                                        <div class="col-4">
											<div class="form-group">
												<input type="text" name="state" id="state" class="form-control" placeholder="State">
											</div>
										</div>

                                        
                                        <div class="col-4">
											<div class="form-group">
												<input type="text" name="zcode" id="zcode" class="form-control" placeholder="Zip Code">
											</div>
										</div>	
									</div>
									<!-- /row -->
									<div class="form-group terms">
										<h6>Do you need business setup assistance?</h6>
											<div class="row">
                                            
                                            <div class="col-sm-3"><label class="container_check">Yes
                                            <input type="checkbox" name="business_setup_asst" id="business_setup_asst" value="Yes">
											<span class="checkmark"></span></label>
                                            </div>
                                            
                                            <div class="col-sm-3"><label class="container_check">No
                                                <input type="checkbox" name="business_setup_asst" id="business_setup_asst" value="No">
                                                <span class="checkmark"></span></label>
                                            </div>
                                            
                                            <div class="col-sm-4"><label class="container_check">Not Sure
                                                <input type="checkbox" name="business_setup_asst"  id="business_setup_asst" value="Not Sure">
                                                <span class="checkmark"></span></label>
                                            </div>           
								</div>
									</div>
                                    <div class="form-group terms">
										<h6>Do you need contract finding and/or bidding assistance?</h6>
											<div class="row">
                                            
                                            <div class="col-sm-3"><label class="container_check">Yes
                                            <input type="checkbox" name="bidding_assistance" id="bidding_assistance" value="Yes">
											<span class="checkmark"></span></label>
                                            </div>
                                            
                                                 <div class="col-sm-3"><label class="container_check">No
                                            <input type="checkbox" name="bidding_assistance" id="bidding_assistance" value="No">
											<span class="checkmark"></span></label>
                                            </div>
                                            
                                            <div class="col-sm-4"><label class="container_check">Not Sure
                                            <input type="checkbox" name="bidding_assistance" id="bidding_assistance" value="Not Sure">
											<span class="checkmark"></span></label>
                                            </div>            
								</div>
									</div>
                                    <div class="form-group terms">
										<h6>Are you currently Certified:</h6>
											<div class="row">
                                            
                                            <div class="col-sm-3"><label class="container_check">Yes
                                                <input type="checkbox" name="currently_certified" id="currently_certified" value="Yes">
                                                <span class="checkmark"></span></label>
                                            </div>
                                            
                                            <div class="col-sm-3"><label class="container_check">No
                                                <input type="checkbox" name="currently_certified" id="currently_certified" value="No">
                                                <span class="checkmark"></span></label>
                                            </div>
                                            
                                            <div class="col-sm-4"><label class="container_check">Not Sure
                                                <input type="checkbox" name="currently_certified" id="currently_certified" value="Not Sure">
                                                <span class="checkmark"></span></label>
                                            </div>             
								</div>
									</div>
                                    
                                    <div class="form-group terms">
										<h6>Have you ever bid for a contract?</h6>
											<div class="row">
                                            
                                            <div class="col-sm-3"><label class="container_check">Yes
                                            <input type="checkbox" name="bid_for_contract" id="bid_for_contract" value="Yes">
											<span class="checkmark"></span></label>
                                            </div>
                                            
                                                 <div class="col-sm-3"><label class="container_check">No
                                            <input type="checkbox" name="bid_for_contract" id="bid_for_contract" value="No">
											<span class="checkmark"></span></label>
                                            </div>
                                            
                                            <div class="col-sm-4"><label class="container_check">Not Sure
                                            <input type="checkbox" name="bid_for_contract" id="bid_for_contract" value="Not Sure">
											<span class="checkmark"></span></label>
                                            </div>      
								</div>
									</div>
                                    
                                 <div class="form-group terms">
										<label class="container_check">Yes, I'm interested in knowing more about the new free Contract Ready LA assistance program. 

											<input type="checkbox" name="interest_free_contract" id="interest_free_contract" value="Yes">
											<span class="checkmark"></span>
										</label>
									</div>
                                    
                                    
                                    <div class="form-group terms">
										<label class="container_check">YES! Notify me when the website is LIVE!
											<input type="checkbox" name="noify" id="noify" value="Yes">
											<span class="checkmark"></span>
										</label>
									</div>   
                                    
								</div>
								<!-- /step-->
								
								<!-- /step-->
								
								<!-- /step-->
								
								<!-- /step-->
								
								<!-- /step-->
							</div>
							<!-- /middle-wizard -->
							<div id="bottom-wizard">
							<!-- <a type="submit" name="forward" class="forward"  data-bs-toggle="modal" data-bs-target="#terms-txt">Submit</a> -->
                            <input type="submit" name="submitBtn" id="submitBtn" class="btn btn-info"  value="Submit"> 
							</div>
							<!-- /bottom-wizard -->
						</form>
					</div>
					<!-- /Wizard container -->
			</div>
			<!-- /content-right-->
		</div>
		<!-- /row-->
	</div>
	<!-- /container-fluid -->

	<div class="cd-overlay-nav">
		<span></span>
	</div>
	<!-- /cd-overlay-nav -->

	<div class="cd-overlay-content">
		<span></span>
	</div>
	<!-- /cd-overlay-content -->


	<!-- /menu button -->
	
	<!-- Modal terms -->
	
	<!-- Modal terms -->
	<div class="modal fade" id="terms-txt" tabindex="-1" role="dialog" aria-labelledby="termsLabel" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered">
			<div class="modal-content">
		
				<div class="modal-body">
			    <img src="img/imgpop.png" alt="" class="img-fluid" ></div>
			
			</div>
			<!-- /.modal-content -->
		</div>
		<!-- /.modal-dialog -->
	</div>
	<!-- /.modal -->
	
	<!-- /.modal -->
	
	<!-- COMMON SCRIPTS -->
	<script src="js/jquery-3.5.1.min.js"></script>
    <script src="js/common_scripts.min.js"></script>
	<script src="js/velocity.min.js"></script>
	<script src="js/functions.js"></script>

	<!-- Wizard script -->
	<script src="js/survey_func.js"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.0/jquery.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.1/jquery.validate.min.js"></script>
<script>
  $(document).ready(function () {
    $('#contactForm').validate({
      rules: {
        firstname: {
          required: true
        },
        lastname: {
          required: true
        },
        cname: {
          required: true
        },
        email: {
          required: true,
          email: true
        },
        contact: {
          required: true,
          rangelength: [10, 12],
          number: true
        },
        business_address: {
          required: true
        },
        city: {
          required: true
        },
        state: {
          required: true
        },
        zcode: {
          required: true
        }
      },
      messages: {
        firstname: 'Please enter first name.',
        lastname: 'Please enter last name.',
        cname: 'Please enter companys name.',
        email: {
          required: 'Please enter Email Address.',
          email: 'Please enter a valid Email Address.',
        },
        contact: {
          required: 'Please enter Contact.',
          rangelength: 'Contact should be 10 digit number.'
        },
        business_address: 'Please enter Business Address.',
        city: 'City Required.',
        state: 'State Required',
        zcode: 'Zipcde Required'
      },
      submitHandler: function (form) {
        console.log("form",form);

        var formData = {
          firstname: $("#firstname").val(),
          lastname: $("#lastname").val(),
          cname: $("#cname").val(),
          email: $("#email").val(),
          contact: $("#contact").val(),
          business_address: $("#business_address").val(),
          city: $("#city").val(),
          state: $("#state").val(),
          zcode: $("#zcode").val(),
        };

        console.log("formData",formData);
        
        $.ajax({
          type: "POST",
          url: "test.php",
          data: formData,
          dataType: "json",
          encode: true,
          complete: function(data){  
            console.log("responseText ",data.status );
            if(data.status == 200){
              $("#firstname").val('');
              $("#lastname").val('');
              $("#cname").val('');
              $("#email").val('');
              $("#contact").val('');
              $("#business_address").val('');
              $("#city").val('');
              $("#state").val('');
              $("#zcode").val('');

              $("#currently_certified")prop('checked', false);
              
              $('.modal').modal('show');
            }
            
          } 
        });
        
      }
    });
  });

  

  
</script>
</body>
</html>