function General() {

    "use strict";

    var self = this;
    self.traits = [];
    
    this.initLanguageLoad = function () {
        $("#language").change(function () {  
            var id = $("#language").val();
            localStorage.setItem("langSel", id);
            application.load('language/selected/'+id, '', function (result) { 
                location.reload();
            });
        });
    };
        
    this.initRegister = function () {
        $("#show_msg").hide();
        application.onSubmit('#apply_job_form', function (result) {
            application.showLoader('apply_job_form_button');            
            application.post('apply-jobs', '#apply_job_form', function (res) {
                var result = JSON.parse(application.response);
                application.hideLoader('apply_job_form_button');
                $("#show_msg").html(result.messages);                
                if(result.success == 'true')
                {                    
                    $('#apply_job_form').trigger("reset");
                }
                $("#show_msg").show();
                setTimeout(function() { $("#show_msg").hide(); }, 5000);
            });
        });
    };
    
    this.initContact = function () {
        $("#show_msg").hide();
        application.onSubmit('#contact_form', function (result) {
            application.showLoader('contact_form_button');            
            application.post('save-contact', '#contact_form', function (res) {
                var result = JSON.parse(application.response);
                application.hideLoader('contact_form_button');
                $("#show_msg").html(result.messages);                
                if(result.success == 'true')
                {                    
                    $('#contact_form').trigger("reset");
                }
                $("#show_msg").show();
                setTimeout(function() { $("#show_msg").hide(); }, 5000);
            });
        });
    };
    
    this.formpost = function(path, parameters) {
        var form = $('<form></form>');

        form.attr("method", "post");
        form.attr("action", path);

        $.each(parameters, function(key, value) {
            var field = $('<input></input>');

            field.attr("type", "hidden");
            field.attr("name", key);
            field.attr("value", value);

            form.append(field);
        });

        // The form needs to be a part of the document in
        // order for us to be able to submit it.
        $(document.body).append(form);
        form.submit();
    };
    
    this.initPrivacyPolicy = function () {
        $('.privacy_policy').off();
        $('.privacy_policy').on('click', function () {
            var modal = '#modal-default';
            var id = $(this).data('id');
            id = id ? '/'+id : '';
            var modal_title = lang['privacy_policy'];
            $(modal).modal('show');
            $(modal+' .modal-title').html(modal_title);
            application.load('jobprivacy'+id, modal+' .modal-body-container', function (result) {
                
            });
        });
    };

    this.keyup = function () {
        $("#first_name").keyup(function(){
          if($("#first_name").val() != '')
            $("#firstname_label").removeClass('input-group-name');
          else 
            $("#firstname_label").addClass('input-group-name');
        });
        $("#last_name").keyup(function(){
          if($("#last_name").val() != '')
            $("#lastname_label").removeClass('input-group-family');
          else 
            $("#lastname_label").addClass('input-group-family');
        });
        $("#email").keyup(function(){
          if($("#email").val() != '')
            $("#email_label").removeClass('input-group-email');
          else 
            $("#email_label").addClass('input-group-email');
        });
        $("#country").change(function(){
          if($("#country").val() != '')
            $("#country_label").removeClass('input-group-country');
          else 
            $("#country_label").addClass('input-group-country');
        });
        $("#phone1").keyup(function(){
          if($("#phone1").val() != '')
            $("#contact_label").removeClass('input-group-contact');
          else 
            $("#contact_label").addClass('input-group-contact');
        });
    }

}

$(document).ready(function() {
    var general = new General();
    general.initLanguageLoad();
    general.initRegister();
    general.initContact();
    general.keyup();

    //Job Apply page
    general.initPrivacyPolicy();
    
    var arr = window.location.href.split('/');
    var parameter=arr[arr.length-1].split('?');
    var parameter1=arr[arr.length-2];
    var parameter2=arr[arr.length-3];
//    if(parameter[0] == 'jobs')
//    {
//        $('html, body').scrollTop( $(".fliter-form").offset().top );
//    } else if($.isNumeric(parameter[0])) {
//        $('html, body').scrollTop( $(".grid-bottom").offset().top );
//    } else if(parameter1 == 'jobs') {
//        $('html, body').scrollTop( $(".grid-bottom").offset().top );
//    }
    
    if(parameter2 == 'job')
    {
        // Contact Code
        var input = document.querySelector("#phone1");
        window.intlTelInput(input, {
          // allowDropdown: false,
           //autoHideDialCode: false,
          // autoPlaceholder: "off",
          // dropdownContainer: document.body,
          // excludeCountries: ["us"],
          // formatOnDisplay: false,
          // geoIpLookup: function(callback) {
          //   $.get("http://ipinfo.io", function() {}, "jsonp").always(function(resp) {
          //     var countryCode = (resp && resp.country) ? resp.country : "";
          //     callback(countryCode);
          //   });
          // },
           hiddenInput: "code",
          // initialCountry: "auto",
          // localizedCountries: { 'de': 'Deutschland' },
          // nationalMode: false,
          // onlyCountries: ['us', 'gb', 'ch', 'ca', 'do'],
          // placeholderNumberType: "MOBILE",
           preferredCountries: [],
           separateDialCode: true,

        });
        var iti = window.intlTelInputGlobals.getInstance(input);
        $("input[name='code']").val('+93');

        input.addEventListener("countrychange", function() {
            // do something with iti.getSelectedCountryData()
            var iti = window.intlTelInputGlobals.getInstance(input);
            var countryData =  iti.getSelectedCountryData();
            var dialCode = "+"+countryData.dialCode
            $("input[name='code']").val(dialCode);
        });
    }
    
    // Readmore
    var showChar = 150;
    var ellipsestext = "...";
    var moretext = "show all";
    var lesstext = "show less";
    $('.more').each(function() {
            var content = $(this).html();

            if(content.length > showChar) {

                    var c = content.substr(0, showChar);
                    var h = content.substr(showChar-1, content.length - showChar);

                    var html = c + '<span class="moreellipses">' + ellipsestext+ '&nbsp;</span><span class="morecontent"><span>' + h + '</span>&nbsp;&nbsp;<a href="" class="morelink">' + moretext + '</a></span>';

                    $(this).html(html);
            }

    });

    $(".morelink").click(function(){
            if($(this).hasClass("less")) {
                    $(this).removeClass("less");
                    $(this).html(moretext);
            } else {
                    $(this).addClass("less");
                    $(this).html(lesstext);
            }
            $(this).parent().prev().toggle();
            $(this).prev().toggle();
            return false;
    });
    
    
});

function searchFilter (page_num) {
    page_num = page_num?page_num:0;
    $.ajax({
            url : application.url+'jobs/ajaxPaginationData/'+page_num,
            type : "GET",
            data : {
                'countries' : $('#country').val(),
                'region' : $('#region').val(),
                'search' : $('.job-search-value').val(),
                'limit' : $('#jobs_limit').val(),
                'page' : page_num,
            },
            beforeSend: function () {
                $('.loading').show();
            },
            success : function(data) {
                // do something
                $('#jobs_ajax_search').html(data);
                $('.loading').fadeOut("slow");
            },
            error : function(data) {
                // do something
                console.log("Error")
            }
        });
}