<?php

class AdminDashboardModel extends CI_Model
{
    public function getJobs()
    {
        //Setting session for every parameter of the request
        $this->setSessionValues();

        //First getting total records
        $total = $this->getTotalJobs();
        
        //Setting filters, search and pagination via posted session variables
        $page = $this->getSessionValues('dashboard_jobs_page', 1);
        $per_page = 5;

        $per_page = $per_page < $total ? $per_page : $total;
        $limit = $per_page;
        $offset = ($page == 1 ? 0 : ($page-1)) * $per_page;
        $offset = $offset < 0 ? 0 : $offset;

        $this->db->select('
            jobs.*,
            users.first_name,
            users.last_name,
            users.email as admin_email,
            companies.title as company
        ');
        if (isset($this->session->userdata('admin')['user_type']) && 
                $this->session->userdata('admin')['user_type'] == 'team')
        {
            $this->db->where('users.user_id', $this->session->userdata('admin')['user_id']);
        }
        //$this->db->where('jobs.status', 1);
        $this->db->join('companies', 'companies.company_id = jobs.company_id', 'left');
        $this->db->join('users', 'users.user_id = jobs.added_by', 'left');        
        $this->db->from('jobs');
        $this->db->group_by('jobs.job_id');
        $this->db->order_by('jobs.created_at', 'DESC');
        $this->db->limit($limit, $offset);
        $query = $this->db->get();
        $records = objToArr($query->result());

        //Making pagination for display
        $total_pages = $total != 0 ? ceil($total/$per_page) : 0;
        $pagination = ($offset == 0 ? 1 : ($offset+1));
        $pagination .= ' - ';
        $pagination .= $total_pages == $page ? $total : ($limit*$page);
        $pagination .= ' of ';
        $pagination .= $total;

        //Returning final results
        return array(
            'records' => $records,
            'total' =>  $total,
            'total_pages' => $total_pages,
            'pagination' => $pagination
        );
    }

    public function getTotalJobs()
    {
        if (isset($this->session->userdata('admin')['user_type']) && 
                $this->session->userdata('admin')['user_type'] == 'team')
        {
            $this->db->where('users.user_id', $this->session->userdata('admin')['user_id']);
        }
        //$this->db->where('jobs.status', 1);
        $this->db->join('companies', 'companies.company_id = jobs.company_id', 'left');
        $this->db->join('users', 'users.user_id = jobs.added_by', 'left');
        $this->db->from('jobs');
        $this->db->group_by('jobs.job_id');
        $query = $this->db->get();
        return $query->num_rows();
    }
    
    public function getTotalCompanyJobs()
    {
        if (isset($this->session->userdata('admin')['user_type']) && 
                $this->session->userdata('admin')['user_type'] == 'team')
        {
            $this->db->where('jobs.company_id', $this->session->userdata('admin')['company_id']);
        }
        //$this->db->where('jobs.status', 1);
        $this->db->from('jobs');
        $this->db->group_by('jobs.job_id');
        $query = $this->db->get();
        return $query->num_rows();
    }
}