<form id="admin_ventry_create_update_form">
  <input type="hidden" name="visitor_id" value="<?php echo esc_output($subscribers['visitor_id']); ?>" />
  <input type="hidden" name="visit_entry_id" value="<?php echo esc_output($subscriber_entry['visit_entry_id']); ?>" />
  <div class="modal-body">
    <div class="row">
      <div class="col-md-6">
        <div class="form-group">
          <label>Visitor</label>
          <input type="text" class="form-control" name="visitor_name" readonly value="<?php echo esc_output($subscribers['visitor_name']); ?>">
        </div>
      </div>
	  <div class="col-md-3">
        <div class="form-group">
          <label>Added by</label>
          <input type="text" class="form-control" name="visitor_added_type" readonly value="<?php echo esc_output($subscribers['visitor_added_type']); ?>">
        </div>
      </div>
	  <div class="col-md-3">
        <div class="form-group">
          <label>Added Person</label>
          <input type="text" class="form-control" name="visitor_added_by" readonly value="<?php echo esc_output($subscribers['visitor_added_by']); ?>">
        </div>
      </div>
      <?php if($subscribers['parking'] == 'Yes') { ?>
        <div class="col-md-4">
          <div class="form-group">
            <label>Parking Ticket</label>
            <select class="form-control select2" id="parking_ticket" name="parking_ticket">
              <option value=""><?php echo lang('none'); ?></option>
              <?php foreach ($parking as $key => $value) { ?>
                <option value="<?php echo esc_output($value['parking_id']); ?>" <?php sel($visitor_entry['parking_ticket'], $value['parking_id']); ?> ><?php echo esc_output($value['parking_slot'], 'html'); ?></option>
              <?php } ?>
            </select>
          </div>
        </div>
      <?php } else { ?>
        <div class="col-md-4">
          <div class="form-group">
            <label>Parking not selected.</label>
          </div>
        </div>
      <?php } ?>
      <div class="col-md-4">
        <div class="form-group">
          <label>Entry Time</label>
          <input class="form-control" type="text" name="entry_time" id="entry_time" readonly value="<?php echo esc_output($visitor_entry['entry_time']); ?>" />
        </div>
      </div>
      <div class="col-md-4">
        <div class="form-group">
          <label>Exit Time</label>
          <input class="form-control" type="text" name="exit_time" id="exit_time" readonly value="<?php ($visitor_entry['exit_time'] != '0000-00-00 00:00:00')?$visitor_entry['exit_time']:''; ?>" />
        </div>
      </div>

    </div>          
  </div>
  <div class="modal-footer">
    <button type="button" class="btn btn-default pull-left" data-dismiss="modal"><?php echo lang('close'); ?></button>
    <button type="submit" class="btn btn-primary btn-blue" id="admin_ventry_create_update_form_button"><?php echo lang('save'); ?></button>
  </div>
</form>
<script type="text/javascript">
$("#entry_time").datetimepicker({
	minDate:new Date(),
	disabledDates: [new Date()],
	format: 'yyyy-mm-dd hh:ii'
});
$("#exit_time").datetimepicker({
	minDate:new Date(),
	disabledDates: [new Date()],
	format: 'yyyy-mm-dd hh:ii'
});
</script>